<?php
/**
 * Plugin Name: JNews - JSON-LD
 * Plugin URI: http://jegtheme.com/
 * Description: JNews JSON-LD Schema
 * Version: 11.6.0
 * Author: Jegtheme
 * Author URI: http://jegtheme.com
 * License: GPL2
 */

defined( 'JNEWS_JSONLD' ) or define( 'JNEWS_JSONLD', 'jnews-jsonld' );
defined( 'JNEWS_JSONLD_VERSION' ) or define( 'JNEWS_JSONLD_VERSION', '11.6.0' );
defined( 'JNEWS_JSONLD_URL' ) or define( 'JNEWS_JSONLD_URL', plugins_url( JNEWS_JSONLD ) );
defined( 'JNEWS_JSONLD_FILE' ) or define( 'JNEWS_JSONLD_FILE', __FILE__ );
defined( 'JNEWS_JSONLD_DIR' ) or define( 'JNEWS_JSONLD_DIR', plugin_dir_path( __FILE__ ) );


add_action(
	'init',
	function() {
		require 'fallback-function.php';
	}
);

add_filter(
	'jnews_v11.6.0_plugin_compat',
	function( $plugin_list ){
		$plugin_list[] = 'JNews - JSON-LD';
		return $plugin_list;
	}
);

/**
 * Get jnews option
 *
 * @param $setting
 * @param $default
 * @return mixed
 */
if ( ! function_exists( 'jnews_get_option' ) ) {
	function jnews_get_option( $setting, $default = null ) {
		$options = get_option( 'jnews_option', array() );
		$value   = $default;
		if ( isset( $options[ $setting ] ) ) {
			$value = $options[ $setting ];
		}
		return $value;
	}
}

/**
 * JSONLD Option
 */
add_action( 'jeg_register_customizer_option', 'jnews_jsonld_option' );

if ( ! function_exists( 'jnews_jsonld_option' ) ) {
	function jnews_jsonld_option() {
		require_once 'class.jnews-option-jsonld.php';
		JNews_JSONLD_Option::getInstance();
	}
}


add_filter( 'jeg_register_lazy_section', 'jnews_jsonld_lazy_section' );

if ( ! function_exists( 'jnews_jsonld_lazy_section' ) ) {
	function jnews_jsonld_lazy_section( $result ) {
		$result['jnews_schema_setting'][] = JNEWS_JSONLD_DIR . 'schema-option.php';
		$result['jnews_main_schema'][]    = JNEWS_JSONLD_DIR . 'main-option.php';
		$result['jnews_article_schema'][] = JNEWS_JSONLD_DIR . 'article-option.php';
		return $result;
	}
}


/**
 * JSON LD Class
 */
add_action( 'plugins_loaded', 'jnews_json_ld' );

if ( ! function_exists( 'jnews_json_ld' ) ) {
	function jnews_json_ld() {
		require_once 'class.jnews-jsonld.php';
		JNews_JSONLD::getInstance();
	}
}

add_action( 'admin_notices', 'jnews_jsonld_plugin_notice' );

if ( ! function_exists( 'jnews_jsonld_plugin_notice' ) ) {
	/**
	 * Plugin notice
	 */
	function jnews_jsonld_plugin_notice() {
		if( defined( 'JNEWS_THEME_VERSION' ) && version_compare( JNEWS_THEME_VERSION, '11.6.0', '<' ) ) {

			if( ! defined( 'JNEWS_11_6_0_PLUGIN_COMPAT' ) ) {
				define( 'JNEWS_11_6_0_PLUGIN_COMPAT', true );
				$plugin_list = apply_filters( 'jnews_v11.6.0_plugin_compat', array() );
				$plugins = '';

				foreach ( $plugin_list as $plugin ) {
					$plugins .= '<li>' . $plugin . '</li>';
				}

				echo wp_kses(
					' <div class="notice notice-error">
						<p>
							<span class="jnews-notice-heading">' . __( 'JNews Plugins Compatibility', 'jnews-jsonld' ) . '</span>
							<span>' . __( 'These plugins below only compatible with the <strong>JNews Theme version 11.6.0</strong> and above. Your current JNews version is ' . JNEWS_THEME_VERSION . ', please update JNews theme to the latest version to ensure proper functionality and compatibility.', 'jnews-jsonld' ) . '</span><ul>' .
							$plugins .
							'</ul>
							<span class="jnews-notice-button">
								<a href="' . wp_nonce_url( admin_url( 'update.php?action=upgrade-theme&amp;theme=' . urlencode( JNEWS_THEME_TEXTDOMAIN ) ), 'upgrade-theme_' . JNEWS_THEME_TEXTDOMAIN ) . '" class="button-primary">' . __( 'Update Theme Now', 'jnews-jsonld' ) . '</a>
							</span>
						</p>
					</div>',
					array(
						'div' => array(
							'class' => true,
						),
						'p' => array(),
						'i' => array(
							'class' => true,
						),
						'ul' => array(),
						'li' => array(),
						'strong' => array(),
						'span'   => array(
							'style' => true,
							'class' => true,
						),
						'a'      => array(
							'href'  => true,
							'class' => true,
						),
					)
				);
			}
		}
	}
}

/**
 * Load Text Domain
 */

function jnews_jsonld_load_textdomain() {
	load_plugin_textdomain( JNEWS_JSONLD, false, basename( __DIR__ ) . '/languages/' );
}

jnews_jsonld_load_textdomain();
